﻿using System;
using Moq;
using NUnit.Framework;
using NVCC.Models;
using NVCC.WebUI.Controllers;
using NVCC.WebUI.Infrastructure;
using NVCC.WebUI.Models;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Security.Principal;
using System.Web.Routing;
using System.Collections.Specialized;

namespace NVCC.WebUI.Tests.Controllers
{
    [TestFixture]
    public class RoiControllerTests
    {
       
        private  Mock<IRoiService> _roiServiceMock;
        private Mock<IUserService> _userServiceMock;
        private RoiController _controller;
        private Mock<HttpContextBase> context;
        private Mock<IAccessiblePdfService> _accessiblePdfServiceMock;

        [SetUp]
        public void TestSetUp()
        {
            _roiServiceMock = new Mock<IRoiService>();
            _userServiceMock = new Mock<IUserService>();
             context = new Mock<HttpContextBase>();
            _accessiblePdfServiceMock = new Mock<IAccessiblePdfService>();

            _roiServiceMock.Setup(m => m.RoiSearch(It.IsAny<string>(), It.IsAny<string>(), It.IsAny<string>(), It.IsAny<string>(), It.IsAny<DateTime?>(), It.IsAny<DateTime?>()))
              .Returns(FakeDataManager.RoiSearch());
            _roiServiceMock.Setup(m => m.GetRoiAdminSearchResults(It.IsAny<short>(), It.IsAny<short>(), It.IsAny<DateTime?>(), It.IsAny<DateTime?>(), It.IsAny<string>(), It.IsAny<int>()))
              .Returns(FakeDataManager.GetRoiAdminSearchResults());
            _userServiceMock.Setup(m => m.GetViaUser(It.IsAny<string>(), It.IsAny<string>(), It.IsAny<string>(), It.IsAny<short>()))
                            .Returns(FakeDataManager.GetViaUser(viaBApproved: true));
            _userServiceMock.Setup(m => m.GetVisn()).Returns(FakeDataManager.GetVisn());
            _userServiceMock.Setup(m => m.GetFacilityByVisnId()).Returns(FakeDataManager.GetFacilityByVisnId());
            _roiServiceMock.Setup(m => m.GetUsersByFacilityId(It.IsAny<int>())).Returns(FakeDataManager.GetUsersByFacilityId());
            _controller = new RoiController(_roiServiceMock.Object, _userServiceMock.Object, _accessiblePdfServiceMock.Object);
            HttpContextManager.SetCurrentContext(context.Object);


        }

        [Test]
        public void AccountOfDisclosureSearch_IndexActionGet_ReturnsViewResult()
        {
            // Act  
            var result = _controller.Index() as ViewResult;

            // Assert
            Assert.IsInstanceOf(typeof(ViewResult), result);
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RoiSearhViewModel), result.Model);
        }

        [Test]
        public void AccountOfDisclosureSearch_IndexActionPost_ValidModel()
        {
            //Arrange
            RoiSearhViewModel  model = new RoiSearhViewModel { LastName = "zztest", LastFourOfSsn = "5532" };

            // Act  
            var result = _controller.Index(model) as ViewResult;

            // Assert
            Assert.IsInstanceOf(typeof(ViewResult), result);
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RoiSearhViewModel), result.Model);
            Assert.IsTrue(result.ViewData.ModelState.IsValid);
        }

        [Test]
        public void AccountOfDisclosureSearch_ResultSet()
        {
            RoiSearhViewModel model = new RoiSearhViewModel { LastName = "zztest", LastFourOfSsn = "5532" };

            // Act  
            var result = _controller.Index(model) as ViewResult;

            // Assert
            Assert.IsNotNull(result);
            Assert.IsTrue(model.SearchResults.Count()>=1);
        }

        [Test]
        public void AdminSearch_IndexActionGet_LoadFacilityListByVisn()
        {
            // Act  
            var result = _controller.GetFacilitiesById(8);

            // Assert
            Assert.IsInstanceOf(typeof(ActionResult), result);
            Assert.IsNotNull(result);
        }

        [Test]
        public void AdminSearch_IndexActionGet_LoadUserListByFacility()
        {
            RoiAdminSearchViewModel RoiAdmin = new RoiAdminSearchViewModel();
            // Act  
            var result = _controller.GetUserNameByStation(RoiAdmin);

            // Assert
            Assert.IsInstanceOf(typeof(ActionResult), result);
            Assert.IsNotNull(result);
            Assert.IsTrue(RoiAdmin.UserList.Count == 3);
        }

        [Test]
        public void AdminSearch_IndexActionGet_ReturnsViewResultSet_IF_Block()
        {
            RoiAdminSearchViewModel adminModel = new RoiAdminSearchViewModel();
            // Act  
            var result = _controller.Admin(adminModel) as ViewResult;

            // Assert
            Assert.IsInstanceOf(typeof(ViewResult), result);
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RoiAdminSearchViewModel), result.Model);
        }

        [Test]
        public void AdminSearch_IndexActionGet_ReturnsViewResultSet_Else_Block()
        {
            RoiAdminSearchViewModel adminModel = new RoiAdminSearchViewModel();

            adminModel.facilityId = 516;
            adminModel.selectedVisnId = 8;
            // Act  
            var result = _controller.Admin(adminModel) as ViewResult;

            // Assert
            Assert.IsInstanceOf(typeof(ViewResult), result);
            Assert.IsNotNull(result);
            Assert.IsInstanceOf(typeof(RoiAdminSearchViewModel), result.Model);
            Assert.IsTrue(adminModel.roiAdminSearchList.Count() >= 1);
        }
    }
}
